/*
 * Decompiled with CFR 0.152.
 */
package gloridifice.watersource.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import gloridifice.watersource.common.recipe.WaterLevelItemRecipe;
import gloridifice.watersource.helper.FluidHelper;
import java.util.ArrayList;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class WaterLevelRecipeSerializer<T extends WaterLevelItemRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final int waterLevel;
    private final int waterSaturationLevel;
    private final IFactory<T> factory;

    public WaterLevelRecipeSerializer(IFactory<T> factory, int waterLevel, int waterSaturationLevel) {
        this.waterLevel = waterLevel;
        this.waterSaturationLevel = waterSaturationLevel;
        this.factory = factory;
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonelement);
        String fluidName = JSONUtils.func_151219_a((JsonObject)json, (String)"fluid", (String)"");
        String nbt = JSONUtils.func_151219_a((JsonObject)json, (String)"nbt", (String)"");
        CompoundNBT compoundNBT = null;
        try {
            compoundNBT = JsonToNBT.func_180713_a((String)nbt);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName));
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack stack : ingredient.func_193365_a()) {
            if (compoundNBT != null) {
                stack.func_77982_d(compoundNBT);
            }
            list.add(FluidHelper.fillContainer(stack, fluid));
        }
        Ingredient ingredient1 = Ingredient.func_234819_a_(list.stream());
        int i = JSONUtils.func_151208_a((JsonObject)json, (String)"waterLevel", (int)2);
        int j = JSONUtils.func_151208_a((JsonObject)json, (String)"waterSaturationLevel", (int)2);
        return this.factory.create(recipeId, group, ingredient1, i, j);
    }

    public T read(ResourceLocation resourceLocation, PacketBuffer packetBuffer) {
        String group = packetBuffer.func_150789_c(Short.MAX_VALUE);
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)packetBuffer);
        int wa = packetBuffer.func_150792_a();
        int waS = packetBuffer.func_150792_a();
        return this.factory.create(resourceLocation, group, ingredient, wa, waS);
    }

    public void write(PacketBuffer buffer, T recipe) {
        buffer.func_180714_a(recipe.func_193358_e());
        ((WaterLevelItemRecipe)recipe).getIngredient().func_199564_a(buffer);
        buffer.func_150787_b(((WaterLevelItemRecipe)recipe).getWaterLevel());
        buffer.func_150787_b(((WaterLevelItemRecipe)recipe).getWaterSaturationLevel());
    }

    public static interface IFactory<T extends WaterLevelItemRecipe> {
        public T create(ResourceLocation var1, String var2, Ingredient var3, int var4, int var5);
    }
}

